# Set the environment variables first before running the command.
export HF_ALLOW_CODE_EVAL=1
export HF_DATASETS_TRUST_REMOTE_CODE=true

task=tinyGSM8k
length=512
block_length=4
num_fewshot=5
steps=$((length / block_length))
model="Dream-org/Dream-v0-Base-7B"

baseline
accelerate launch eval.py --model dream \
    --model_args pretrained=${model},max_new_tokens=${length},diffusion_steps=${length},add_bos_token=true,alg=entropy,show_speed=True \
    --tasks ${task} \
    --num_fewshot ${num_fewshot} \
    --batch_size 1 \
    --limit 0.01

# parallel
accelerate launch eval.py --model dream \
    --model_args pretrained=${model},max_new_tokens=${length},add_bos_token=true,block_length=${block_length},alg=confidence_threshold,threshold=0.9,show_speed=True \
    --tasks ${task} \
    --batch_size 1 \
    --confirm_run_unsafe_code \
    --limit 0.01

parallel + dual cache
accelerate launch eval.py --model dream \
    --model_args pretrained=${model},max_new_tokens=${length},add_bos_token=true,block_length=${block_length},alg=confidence_threshold,threshold=0.9,use_cache=true,dual_cache=true,show_speed=True \
    --tasks ${task} \
    --batch_size 1 \
    --confirm_run_unsafe_code \
    --limit 0.01


semantic
accelerate launch eval_semantic.py --model dream \
    --model_args pretrained=${model},max_new_tokens=${length},add_bos_token=true,block_length=${block_length},alg=confidence_threshold,threshold=0.9,delimiter_threshold=0.3,use_cache=true,show_speed=true \
    --tasks ${task} \
    --batch_size 1 \
    --confirm_run_unsafe_code \
    --limit 0.01

# semantic + dual cache
accelerate launch eval_semantic.py --model dream \
    --model_args pretrained=${model},max_new_tokens=${length},add_bos_token=true,block_length=${block_length},alg=confidence_threshold,threshold=0.9,delimiter_threshold=0.3,use_cache=true,dual_cache=true,show_speed=true \
    --tasks ${task} \
    --batch_size 1 \
    --confirm_run_unsafe_code \
    --limit 0.01